<?php

/*
+--------------------------------------------------------------------------
|   Invision Power Board v2.0.0
+---------------------------------------------------------------------------
|
|   > Simple chat Module
|   > Module written by d1
|   > Date started: 2nd December 2004
|
|        > Module Version Number: 1.0a1
+--------------------------------------------------------------------------
*/


if ( ! defined( 'IN_IPB' ) )
{
        print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
        exit();
}

class  simplechat {

        var $output     = "";
        var $extra_html = "";
        var $page_title = "Simple Chat";
        var $nav        = array();
        var $tiny_out   = 0;
        var $parser;

        var $msg_refresh    = 5;
        var $online_refresh = 30;

        var $room       = 1;
        var $member     = array();
        var $html       = "";

    //------------------------------------------------------
    // @constructor
    //------------------------------------------------------

    function auto_run()
    {
                global $ibforums, $DB, $std, $print;

                //$ibforums->lang = $std->load_words($ibforums->lang, 'lang_reputation', $ibforums->lang_id);

                $this->html     = $std->load_template('skin_simplechat');

                switch($ibforums->input['CODE'])
                {
                        case 'special':

                                break;

                        case 'msgserv':
                                $this->show_messages();
                                break;

                        case 'msgserv_small':
                                $this->show_messages( 10 );
                                break;

                        case 'onlineserv':
                                $this->show_online();
                                break;

                        case 'add':
                                $this->msg_add();
                                break;

                        case 'color_pick':
                                $this->pick_color();
                                break;

                        case 'mood_pick':
                                $this->pick_mood();
                                break;

                        case 'do_mood_pick':
                                $this->do_pick_mood();
                                break;

                        default:
                                $this->init_chat();
                                break;
                }

                $this->do_output();

    }

    function do_output()
    {
            global $ibforums, $DB, $std, $print;

            $macros = unserialize(stripslashes($ibforums->skin['_macro']));

            if ( ! $this->tiny_out )
            {
                   $css = $print->_get_css();
            }

            foreach( $macros as $i => $row )
            {
                        if ($row['macro_value'] != "")
                        {
                                $html = str_replace( "<{".$row['macro_value']."}>", $row['macro_replace'], $html );
                        }
            }

            $this->output = str_replace( "<#IMG_DIR#>", $ibforums->skin['_imagedir'], $this->output );
            $this->output = str_replace( "<#EMO_DIR#>", $ibforums->skin['_emodir']  , $this->output );

            //-----------------------------------------
            // Images on another server? uncomment and alter below
            //-----------------------------------------

            if ( $ibforums->vars['ipb_img_url'] )
            {
                 $this->output = preg_replace( "#img\s+?src=[\"']style_(images|avatars|emoticons)(.+?)[\"'](.+?)?".">#is", "img src=\"".$ibforums->vars['ipb_img_url']."style_\\1\\2\"\\3>", $this->output );
            }

            $print->_finish();

            if ( ! $this->tiny_out )
            {
                   echo $this->html->main_wrapper( $this->page_title, $css, $this->output, $this->extra_html);
            }
            else
            {
                   echo "<meta http-equiv=\"content-type\" content=\"text/html; charset=windows-1251\" /> \n".$this->output;
            }

            return;
    }

    function pick_color()
    {
            global $ibforums, $DB, $std;

            $color = $std->my_getcookie('chat_msg_color');

            $this->output = $this->html->color_picker( $color );

            return;
    }

    function pick_mood()
    {
            global $ibforums, $DB, $std;

            if ( $ibforums->member['id'] )
            {
                 $mood = $DB->simple_exec_query( array ( 'select' => 'chat_mood', 'from' => 'member_extra', 'where' => 'id='.$ibforums->member['id'] ) );
            }
            else
            {
                 $this->output = "You are not allowed to do that";
                 return;
            }

            $show_table = 0;
            $count      = 0;

            $smilies    = "<tr align='center'>\n";

            //-----------------------------------------
            // Get the smilies from the DB
            //-----------------------------------------

            if ( ! is_array( $ibforums->cache['emoticons'] ) )
            {
                   $ibforums->cache['emoticons'] = array();

                   $DB->simple_construct( array( 'select' => 'typed,image,clickable,emo_set', 'from' => 'emoticons' ) );
                   $DB->simple_exec();

                   while ( $r = $DB->fetch_row() )
                   {
                           $ibforums->cache['emoticons'][] = $r;
                   }
            }

            $r['emo_set'] = $ibforums->skin['_emodir'];
            $r['typed']   = "";
            $r['image']   = "none";

            $ibforums->cache['emoticons'][] = $r;

            foreach( $ibforums->cache['emoticons'] as $a_id => $elmo )
            {
                     if ( $elmo['emo_set'] != $ibforums->skin['_emodir'] )
                     {
                          continue;
                     }

                     $show_table++;
                     $count++;

                     //-----------------------------------------
                     // Make single quotes as URL's with html entites in them
                     // are parsed by the browser, so ' causes JS error :o
                     //-----------------------------------------

                     $elmo['typed'] = str_replace("&quot;",'\\"',$elmo['typed']);

                     if ( $mood['chat_mood'] == $elmo['typed'] )
                     {
                          $checked = "checked='1'";
                     }
                     else
                     {
                          $checked = "";
                     }

                     if ( $elmo['image'] != "none" )
                     {
                          $smilies .= "<td><input type='radio' name='mood' value=\"{$elmo['typed']}\" $checked /><img src=\"".$ibforums->vars['EMOTICONS_URL']."/".$elmo['image']."\" alt='smilie' border='0' />&nbsp;\n</td>";
                     }
                     else
                     {
                          $smilies .= "<td><input type='radio' name='mood' value=\"{$elmo['typed']}\" $checked />None&nbsp;\n</td>";
                     }

                     if ($count == 3)
                     {
                         $smilies .= "</tr>\n\n<tr align='center'>";
                         $count = 0;
                     }

            }

            $this->output = $this->html->mood_picker();

            $this->output = preg_replace( "/<!--MOODS-->/", $smilies, $this->output );

            return;
    }

    function do_pick_mood()
    {
            global $ibforums, $DB, $std;

            if ( $ibforums->member['id'] )
            {
                 $ibforums->input['mood'] = htmlspecialchars(trim($ibforums->input['mood']));

                 $DB->simple_exec_query ( array( 'update' => 'member_extra',
                                                 'set'    => 'chat_mood="'.$ibforums->input['mood'].'"',
                                                 'where'  => 'id='.$ibforums->member['id'] ) );
            }

            $this->output  = "<SCRIPT TYPE='text/javascript' LANGUAGE='javascript1.2'>
            <!--//
            self.close();
            //-->
            </SCRIPT>";

            return;
    }

    function show_messages( $limit="50" )
    {
            global $ibforums, $DB, $std;

            if ($limit == 0) $limit = 10;

            $messages  = "";
            $check_img = $std->my_getcookie('chat_selpmimgs');

            $last_id   = $std->my_getcookie('chat_last_id');
            $last_time = $std->my_getcookie('chat_last_time');

            if ( $ibforums->input['reset'] )
            {
                $std->my_setcookie('chat_last_id', 0);
                $std->my_setcookie('chat_last_time', 0);

                $last_id   = 0;
                $last_time = 0;
            }


            $last_id   = ( $last_time >= ( time() - 5*60 ) ) ? intval($last_id) : 0;

            if ($last_id <= 0)
            {
                    $DB->simple_construct ( array ( 'select' => '*',
                                                    'from'   => 'chat_messages',
                                                    'where'  => 'room='.intval($this->room).' AND ( to_mid='.intval($ibforums->member['id']).' OR to_mid=0 )',
                                                    'order'  => 'time DESC',
                                                    'limit'  => array (0,$limit), ) );
            }
            else
            {
                    $DB->simple_construct ( array ( 'select' => '*',
                                                    'from'   => 'chat_messages',
                                                    'where'  => 'room='.intval($this->room).' AND ( to_mid='.intval($ibforums->member['id']).' OR to_mid=0 ) AND id > '.$last_id,
                                                    'order'  => 'time DESC', ) ) ;
                                                   // 'limit'  => array (0,$limit), ) );
            }

            $DB->simple_exec();

            while ( $r = $DB->fetch_row() )
            {
                    $row[$r['id']] = $r;
            }

            ksort ($row);

            foreach ( $row as $r  )
            {
                    if ( $r['to_mid'] == $ibforums->member['id'] or $r['mid'] == $ibforums->member['id'] or ! $r['to_mid'] )
                    {
                         if ( $r['mid'] )
                         {
                                $r['name'] = $r['name'];
                         }
                         else
                         {
                                $r['name'] = "Guest";
                         }

                         $r['html_name'] = $ibforums->cache['group_cache'][$r['mgroup']]['prefix'].$r['name'].$ibforums->cache['group_cache'][$r['mgroup']]['suffix'];

                         if ( $r['color'] != '' )
                         {
                              $r['text'] = "<font color='".$r['color']."'>".$r['message']."</font>";
                         }
                         else
                         {
                              $r['text'] = "<font color='#000000'>".$r['message']."</font>";
                         }

                         $r['msg_extra']  = "(".$std->get_time( $r['time'], 'G:i:s').")";

                         $image = ( $r['id'] == $check_img ) ? $ibforums->vars['img_url']."/private_on.gif" : $ibforums->vars['img_url']."/private_off.gif";

                         if ( $r['to_mid'] and $r['mid'] == $ibforums->member['id'] )
                         {
                              $r['msg_extra'] .= " <a onmouseover='this.style.cursor=\"pointer\"' title='Personal Message' onclick='toggle_pm(\"".$r['to_mid']."\",\"".$r['id']."\"); return false;'><img name='img".$r['id']."' src='".$image."' /></a> ";
                         }
                         else
                         {
                              $r['msg_extra'] .= " <a onmouseover='this.style.cursor=\"pointer\"' title='Personal Message' onclick='toggle_pm(\"".$r['mid']."\",\"".$r['id']."\"); return false;'><img name='img".$r['id']."' src='".$image."' /></a> ";
                         }

                         if ( $r['to_mid'] and $r['to_mid'] == $ibforums->member['id'] )
                         {
                                 $r['msg_extra'] .= " Private message from ";
                         }
                         else if ( $r['to_mid'] and $r['mid'] == $ibforums->member['id'] )
                         {
                                 $r['msg_extra'] .= " Private message to ";

                                 if ( $r['to_mid_name'] != "" )
                                 {
                                    $r['name'] = $r['to_mid_name'];
                                 }
                                 else
                                 {
                                    $r['name'] = "Guest";
                                 }

                                 $r['html_name'] = $ibforums->cache['group_cache'][$r['to_mid_mgroup']]['prefix'].$r['name'].$ibforums->cache['group_cache'][$r['to_mid_mgroup']]['suffix'];
                         }

                         $messages .= $this->html->chat_messages_msg( $r );
                    }

                    $new_last_id = $r['id'];
            }

            $std->my_setcookie('chat_last_id', $new_last_id);
            $std->my_setcookie('chat_last_time', time());

            $messages = str_replace ( "\n", "", $messages );
            $messages = str_replace ( "\r", "", $messages );

            if ( $ibforums->member['g_access_cp'] )
            {
                 $messages .= "<!--rem-->Server load: ".$ibforums->server_load."<!--/rem-->";
            }

            $this->tiny_out = 1;

            if ( $last_id > 0 )
            {
                $this->output  = "<SCRIPT TYPE='text/javascript' LANGUAGE='javascript1.2'>
                                <!--
                                if ( window.parent.document && window.parent.document.getElementById('chatwindow') )
                                {
                                     var re;
                                     re = /<!--rem-->.+?<!--\/rem-->/g;
                                     window.parent.document.getElementById('chatwindow').innerHTML = window.parent.document.getElementById('chatwindow').innerHTML.replace( re, '');
                                     window.parent.document.getElementById('chatwindow').innerHTML+=\"".addslashes($messages)."\";
                                     window.parent.document.getElementById('chatwindow').scrollTop=window.parent.document.getElementById('chatwindow').scrollHeight;
                                }
                                //-->
                                </SCRIPT>";
            }
            else
            {
                $this->output  = "<SCRIPT TYPE='text/javascript' LANGUAGE='javascript1.2'>
                                <!--
                                if ( window.parent.document && window.parent.document.getElementById('chatwindow') )
                                {
                                     window.parent.document.getElementById('chatwindow').innerHTML=\"".addslashes($messages)."\";
                                     window.parent.document.getElementById('chatwindow').scrollTop=window.parent.document.getElementById('chatwindow').scrollHeight;
                                }
                                //-->
                                </SCRIPT>";
            }
            //-----------------------------------------
            // Task image
            //-----------------------------------------

            if ( time() >= $ibforums->cache['systemvars']['task_next_run'] )
            {
                 $this->output .= "<!--TASK--><img src='{$ibforums->base_url}act=task' border='0' height='1' width='1' /><!--ETASK-->";
            }

            $this->output .= "<meta http-equiv='refresh' content='5; url=index.php?act=simplechat&amp;CODE=".$ibforums->input['CODE']."' />";

            return;
    }

    function show_online()
    {
            global $ibforums, $DB, $std;

            $online_list = "";
            $moods       = array();
            $rows        = array();

            //-----------------------------------------
            // Get the smilies from the DB
            //-----------------------------------------

            if ( ! is_array( $ibforums->cache['emoticons'] ) )
            {
                   $ibforums->cache['emoticons'] = array();

                   $DB->simple_construct( array( 'select' => 'typed,image,clickable,emo_set', 'from' => 'emoticons' ) );
                   $DB->simple_exec();

                   while ( $r = $DB->fetch_row() )
                   {
                           $ibforums->cache['emoticons'][] = $r;
                   }
            }

            foreach ( $ibforums->cache['emoticons'] as $v )
            {
                      if ( $v['emo_set'] == $ibforums->skin['_emodir'] )
                      {
                          $moods[ $v['typed'] ] = $v['image'];
                      }
            }

            $cut_off = $ibforums->vars['au_cutoff'] * 60;
            $time    = time() - $cut_off;

            $DB->simple_construct ( array ( 'select' => 's.member_id, s.member_name, s.member_group, me.chat_mood',
                                            'from'   => 'sessions s LEFT JOIN ibf_member_extra me ON (s.member_id=me.id)',
                                            'where'  => "s.running_time > $time AND s.location LIKE 'simplechat%'",
                                            'order'  => "s.running_time DESC",
                                            ) );

            $DB->simple_exec();

            while ( $r = $DB->fetch_row() )
            {
                    if ( $r['member_id'] )
                    {
                         $r['name'] = $r['member_name'];
                    }
                    else
                    {
                         $r['name'] = "Guest";
                    }

                    $r['html_name'] = $ibforums->cache['group_cache'][$r['member_group']]['prefix'].$r['name'].$ibforums->cache['group_cache'][$r['member_group']]['suffix'];

                    $image = ( $r['id'] == $check_img ) ? $ibforums->vars['img_url']."/private_on.gif" : $ibforums->vars['img_url']."/private_off.gif";

                    $r['extra'] .= " <a onmouseover='this.style.cursor=\"pointer\"' title='Personal Message' onclick='toggle_pm(\"".$r['mid']."\",\"".$r['id']."\"); return false;'><img name='img".$r['id']."' src='".$image."' /></a> ";

                    if ( $r['chat_mood'] != "" )
                    {
                         $r['mood'] = "<img src=\"".$ibforums->vars['EMOTICONS_URL']."/".$moods[$r['chat_mood']]."\" alt='smilie' border='0' />";
                    }

                    $rows[$r['member_id']] = $r;
            }

            foreach ( $rows as $v )
            {
                    $online_list .= $this->html->chat_online_user( $v )."<br />";
            }

            $online_list = str_replace ( "\n", "", $online_list );

            $this->tiny_out = 1;

            $this->output  = "<SCRIPT TYPE='text/javascript' LANGUAGE='javascript1.2'>
            <!--
            if ( window.parent.document.getElementById('online') )
            {
                 window.parent.document.getElementById('online').innerHTML='".addslashes($online_list)."';
            }
            //-->
            </SCRIPT>";

            $this->output .= "<meta http-equiv='refresh' content='20' />";

            return;
    }

    function msg_add()
    {
            global $ibforums, $DB, $std;

            if ( trim($ibforums->input['Post_post']) == "" )
            {
                 return;
            }

            if ( ! $ibforums->member['id'] )
            {
                 return;
            }

            $std->my_setcookie('chat_selpmimgs', 0, 0);

            require( ROOT_PATH.'sources/lib/post_parser.php');

            $this->parser  = new post_parser();



            $ibforums->input['Post_post'] = $this->parser->convert( array( 'TEXT'    => $ibforums->input['Post_post'],
                                                                           'SMILIES' => 1,
                                                                           'CODE'    => 1,
                                                                           'HTML'    => 0,
                                                             )                );

            $ibforums->input['room']   = intval ( $ibforums->input['room']   );
            $ibforums->input['to_mid'] = intval ( $ibforums->input['to_mid'] );

            if ( $ibforums->input['to_mid'] )
            {
                 $pm_name = $DB->simple_exec_query ( array ('select' => 'name, mgroup', 'from' => 'members', 'where' => 'id='.$ibforums->input['to_mid'] ) );
            }
            else
            {
                 unset ( $pm_name );
            }

            $DB->do_insert( 'chat_messages', array( 'mid'         => $ibforums->member['id'],
                                                    'name'        => $ibforums->member['name'],
                                                    'mgroup'      => $ibforums->member['mgroup'],
                                                    'time'        => time(),
                                                    'message'     => $ibforums->input['Post_post'],
                                                    'to_mid'      => $ibforums->input['to_mid'],
                                                    'room'        => $ibforums->input['room'],
                                                    'ip_address'  => $ibforums->input['IP_ADDRESS'],
                                                    'color'       => $ibforums->input['color'],
                                                    'to_mid_name' => $pm_name['name'],
                                                    'to_mid_mgroup' => $pm_name['mgroup'],
                                             )                                      );

            return;
    }

    function init_chat()
    {
            global $ibforums, $DB, $std;

            $input = "";

            $std->my_setcookie('chat_last_id', 0);
            $std->my_setcookie('chat_last_time', 0);

            $this->output = $this->html->chat_main();

            $this->output = preg_replace ( "/<!--MESSAGES-->/", $this->html->chat_messages(), $this->output );
            $this->output = preg_replace ( "/<!--ONLINE-->/", $this->html->chat_online(), $this->output );

            $input = $this->html->chat_inputform( array( 'mid'   => $ibforums->member['id'],
                                                         'room'  => $this->room,
                                                         'color' => htmlspecialchars( substr( $std->my_getcookie('chat_msg_color'), 0, 7 ) ),
                                                       ) );

            $this->output = preg_replace ( "/<!--INPUT-->/", $input, $this->output );

            $this->output = $this->html_add_smilie_box( $this->output );

            return;
    }

        function html_add_smilie_box($in_html="")
        {
                global $ibforums, $DB;

                $show_table = 0;
                $count      = 0;

                //-----------------------------------------
                // Get the smilies from the DB
                //-----------------------------------------

                if ( ! is_array( $ibforums->cache['emoticons'] ) )
                {
                        $ibforums->cache['emoticons'] = array();

                        $DB->simple_construct( array( 'select' => 'typed,image,clickable,emo_set', 'from' => 'emoticons' ) );
                        $DB->simple_exec();

                        while ( $r = $DB->fetch_row() )
                        {
                                $ibforums->cache['emoticons'][] = $r;
                        }
                }

                usort( $ibforums->cache['emoticons'] , array( 'simplechat', 'smilie_alpha_sort' ) );

                foreach( $ibforums->cache['emoticons'] as $a_id => $elmo )
                {
                        if ( $elmo['emo_set'] != $ibforums->skin['_emodir'] )
                        {
                                continue;
                        }

                        if ( ! $elmo['clickable'] )
                        {
                                continue;
                        }

//                        if ($count >= $ibforums->vars['qr_max_emo'] and $ibforums->vars['qr_max_emo'] != 0 )
//                        {
//                                break;
//                        }

                        $show_table++;
                        $count++;

                        //-----------------------------------------
                        // Make single quotes as URL's with html entites in them
                        // are parsed by the browser, so ' causes JS error :o
                        //-----------------------------------------

                        $elmo['typed'] = str_replace("&quot;",'\\"',$elmo['typed']);
                        $smilies .= "<a href='javascript:emoticon(\"{$elmo['typed']}\")'><img src=\"".$ibforums->vars['EMOTICONS_URL']."/".$elmo['image'].
                        "\" alt=\"".$elmo['typed']."\" border='0' /></a>&nbsp;\n";
                }

                $in_html = preg_replace( "/<!--EMOTICONS-->/", $smilies, $in_html );

                return $in_html;
        }

        function smilie_alpha_sort($a, $b)
        {
                return strcmp( $a['typed'], $b['typed'] );
        }


}