<?php
/* vim: set ai tabstop=4: */
// $Date: 2002/05/11 02:20:46 $
// $Revision: 1.2 $

/**
* LYCOS.CO.UK class (21-APR-2002)
*/
class lycos_co_uk extends sms_base
{
	//-------------------------
	// LOGIN
	// vars - [[USER]] [[PASS]]
	//-------------------------
	var $login_script = 'http://login.lycos.co.uk/bin/membership/len_login?StatusCookie=OK';
	var $login_command = 'member_name=[[USER]]&service=lycos&redirect=http%3A%2F%2Fsms.lycos.co.uk%2Fmobile%2F&target_url=&fail_url=&format=&password=[[PASS]]&product=SMS&x=20&y=10';

	// check for this URL
	var $success_url = '/bin/membership/len_cookie';

	// next URL
	var $next_url = '/mobile/message_center/message_center.jsp';

	// message delivered url
	var $message_delivered_url = '/mobile/message_center/message_delivered.jsp';

	//-------------------------
	// SEND SMS
	// vars - [[TS]] [[NUM]] [[MSG]]
	//-------------------------
	// check for success string
	var $success_string = 'SMS message sent to:';

	// check for quota string
	var $quota_exceeded_string = 'You tried to send';

	// send command
	var $send_command = 'myaction=send&timestamp=[[TS]]&buddy=No+buddies&recsource=receiver&receiver=[[NUM]]&format=sms&body=[[MSG]]&phrase=--+Select+a+phrase+--';

	// send URL
	var $send_script = 'http://sms.lycos.co.uk/mobile/message_center/message_center.jsp';

	// message
	var $send_message = '[[MSG]]';

	// logout URL
	var $logout_script = 'http://login.lycos.co.uk/bin/membership/len_logout?redirect=http:%2F%2Fsms.lycos.co.uk%2Fmobile';

	// failure checks
	var $fail = array();

	
	/**************************
	 constructor
	***************************/
	function lycos_co_uk()
	{
		//-------------------------
		// FAILED LOGINS CLUES
		// vars - [[USER]]
		//-------------------------
		$this->fail[0]['check_type']	= 'body';
		$this->fail[0]['check_for']	= '<b>ERROR:</b> The password supplied for';
		$this->fail[0]['debug_msg']	= 'Incorrect password for user: [[USER]]';

		$this->fail[1]['check_type']	= 'body';
		$this->fail[1]['check_for']	= '<b>ERROR:</b> There is no member';
		$this->fail[1]['debug_msg']	= 'User name not found: [[USER]]';
	}

	/**************************
	 login
	***************************/
	function login(&$sms_obj)
	{
		// grab login string 
		$command = $this->login_command;
		$command = str_replace('[[USER]]', urlencode($sms_obj->get_username()), $command);
		$command = str_replace('[[PASS]]', urlencode($sms_obj->get_password()), $command);

		$result = $sms_obj->post_url($this->login_script, $command);
		$redirect_url = $sms_obj->http->get_info('redirect');

		// check for incorrect login details
		if (is_array($this->fail)) {
			for ($x=0; $x < count($this->fail); $x++) {
				$check_in = ($this->fail[$x]['check_type'] == 'body') ? $result : $redirect_url;
				if (strstr($check_in, $this->fail[$x]['check_for']) != '') {
					$sms_obj->debug(str_replace('[[USER]]', $sms_obj->get_username(), $this->fail[$x]['debug_msg']));
					return array('error'=>SWS_ERR_USER_PASS);
				}
			}
		}

		if (strstr($redirect_url, $this->success_url)) {
			$sms_obj->debug('Redirect URL matches Success URL: '.$this->success_url);
		}
		return true;
	}

	/**************************
	 send sms
	***************************/
	function send_sms($op, &$sms_obj)
	{
		// $op : array with keys: 'msg', 'num', 'ccode'
		// eg. 'msg'=>'test message', 'ccode'=>'+44', 'num'=>'7929342829'

		if (is_array($error = $this->login($sms_obj))) {
			$sms_obj->debug('Unable to log in');
			return $error;
		}

		$message = str_replace('[[MSG]]', $op['msg'], $this->send_message);

		$command = $this->send_command;
		$command = str_replace('[[NUM]]', urlencode($op['ccode'].$op['num']), $command);
		$command = str_replace('[[MSG]]', urlencode($message), $command);
		$command = str_replace('[[TS]]', time(), $command);

		$result = $sms_obj->post_url($this->send_script, $command);

		if (strstr($result, $this->message_delivered_url)) {
			$sms_obj->debug('SMS Message Sent Successfully');
			return true;
		} else {
			$sms_obj->debug('SMS Send Failed');
			if (strstr($result, $this->quota_exceeded_string)) {
				$sms_obj->debug('Quota for current user ['.$sms_obj->get_username().'] exceeded.');
				return array('error'=>SWS_ERR_QUOTA);
			}
			return array('error'=>SWS_ERR_SEND);
		}
	}

	/**************************
	 logout
	***************************/
	function logout(&$sms_obj)
	{
		$sms_obj->debug('Logging out...');
		$sms_obj->get_url($this->logout_script);
		return true;
	}
}
?>