<?php
/* vim: set ai tabstop=4: */
// $Date: 2002/05/11 02:20:46 $
// $Revision: 1.2 $

/**
* SMS.AC class (21-APR-2002)
*/
class sms_ac extends sms_base
{
	//-------------------------
	// LOGIN
	// vars - [[USER]] [[PASS]]
	//-------------------------
	var $login_script = 'http://www.sms.ac/login.asp';
	var $login_command = 'loginuserid=[[USER]]&loginpassword=[[PASS]]&login=Sign+In';

	//-------------------------
	// SEND SMS
	// vars - [[TIMESTAMP]] [[GSM_NUMBER]] [[MESSAGE]] [[SIG]]
	//-------------------------
	// check for success string
	var $success_string = 'been sent to the person';

	// check for quota string
	var $quota_exceeded_string = 'limit has been reached';

	// send command
	var $send_command = 'mobilenumber=[[NUM]]&message=[[MSG]]&sizebox=19&SendSMS=Send+SMS';

	// send URL
	var $send_script = 'http://www.sms.ac/default2.asp';

	// message
	var $send_message = '[[MSG]]';

	// logout URL
	var $logout_script = 'http://www.sms.ac/SignOut.asp';

	// failure checks
	var $fail = array();

	
	/**************************
	 constructor
	***************************/
	function sms_ac()
	{
		//-------------------------
		// FAILED LOGINS CLUES
		// vars - [[USER]]
		//-------------------------
		$this->fail[0]['check_type']	= 'body';
		$this->fail[0]['check_for']	= 'ID and Password do not match';
		$this->fail[0]['debug_msg']	= 'Incorrect User or Pass for user: [[USER]]';
	}

	/**************************
	 login
	***************************/
	function login(&$sms_obj)
	{
		// grab login string 
		$command = $this->login_command;
		$command = str_replace('[[USER]]', urlencode($sms_obj->get_username()), $command);
		$command = str_replace('[[PASS]]', $sms_obj->get_password(), $command);

		// get cookies set
		$result = $sms_obj->get_url($this->login_script);
		// send login
		$result = $sms_obj->post_url($this->login_script, $command);
		$redirect_url = $sms_obj->http->get_info('redirect');
		
		// check for incorrect login details
		if (is_array($this->fail)) {
			for ($x=0; $x < count($this->fail); $x++) {
				$check_in = ($this->fail[$x]['check_type'] == 'body') ? $result : $redirect_url;
				if (strstr($check_in, $this->fail[$x]['check_for']) != '') {
					$sms_obj->debug(str_replace('[[USER]]', $sms_obj->get_username(), $this->fail[$x]['debug_msg']));
					return array('error'=>SWS_ERR_USER_PASS);
				}
			}
		}

		if (!$redirect_url) {
			return array('error'=>SWS_ERR_UNKNOWN);
		}

		return true;
	}

	/**************************
	 send sms
	***************************/
	function send_sms($op, &$sms_obj)
	{
		// $op : array with keys: 'msg', 'num', 'ccode'
		// eg. 'msg'=>'test message', 'ccode'=>'+44', 'num'=>'7929342829'

		if (is_array($error = $this->login($sms_obj))) {
			$sms_obj->debug('Unable to log in');
			return $error;
		}

		$message = str_replace('[[MSG]]', $op['msg'], $this->send_message);

		$command = $this->send_command;
		$command = str_replace('[[NUM]]', urlencode(str_replace('+', '', $op['ccode'].$op['num'])), $command);
		$command = str_replace('[[MSG]]', urlencode($message), $command);

		$result = $sms_obj->post_url($this->send_script, $command);
		
		if ($redirect_url = $sms_obj->http->get_info('redirect')) {
			$sms_obj->get_url($redirect_url);
			$result = $sms_obj->http->get_body();
		}

		if (strstr($result, $this->success_string)) {
			$sms_obj->debug('SMS Message Sent Successfully');
			return true;
		} else {
			$sms_obj->debug('SMS Send Failed');
			if (strstr($result, $this->quota_exceeded_string)) {
				$sms_obj->debug('Quota for current user ['.$sms_obj->get_username().'] exceeded.');
				return array('error'=>SWS_ERR_QUOTA);
			}
			return array('error'=>SWS_ERR_SEND);
		}
	}

	/**************************
	 logout
	***************************/
	function logout(&$sms_obj)
	{
		$sms_obj->debug('Logging out...');
		$sms_obj->get_url($this->logout_script);
		return true;
	}
}
?>