<?php
/* vim: set ai tabstop=4: */
// $Date: 2002/05/11 02:22:46 $
// $Revision: 1.2 $

/**
* VIZZAVI.CO.UK class (11-May-2002)
*/
class vizzavi_co_uk extends sms_base
{

	//-------------------------
	// LOGIN
	// vars - [[USER]] [[PASS]]
	//-------------------------
	var $pre_login_script = 'http://www.vizzavi.co.uk/vizloginpage';
	var $login_script = 'http://www.vizzavi.co.uk/[[SESS]]/vizloginpage';
	var $login_command = 'username=[[USER]]&password=[[PASS]]&submit.x=11&submit.y=11';
	// will be grabbed from login page
	var $session_id = '';

	//-------------------------
	// SEND SMS
	// vars - [[NUM]] [[MSG]] [[SIG]]
	//-------------------------
	// check for success string
	var $success_string = 'text message has been sent';

	// check for quota string
	var $quota_exceeded_string = 'You have used up your 10 free text messages';

	// confirm command
	var $confirm_command = 'phoneNumber=[[NUM]]&countryCode=44&messageArea=[[MSG]]&smsMessage=[[MSG]]&remain=[[REMAIN]]&imageField.x=24&imageField.y=18';

	// send command
	var $send_command = 'countryCode=44&phoneNumber=[[NUM]]&smsMessage=[[MSG]]&x=30&y=7';

	// pre confirm URL
	var $preconfirm_script = 'http://www.vizzavi.co.uk/[[SESS]]/web2Sms/Web2SmsAuthServlet';

	// confirm URL
	var $confirm_script = 'http://www.vizzavi.co.uk/[[SESS]]/web2SmsPages/jsp/web2SmsConfirm.jsp';

	// send URL
	var $send_script = 'http://www.vizzavi.co.uk/[[SESS]]/web2Sms/Web2SmsSendServlet';

	// message
	var $send_message = '[[MSG]]';

	// logout URL
	var $logout_script = 'http://www.vizzavi.co.uk/[[SESS]]/vizlogoutpage';

	// failure checks
	var $fail = array();

	
	/**************************
	 constructor
	***************************/
	function vizzavi_co_uk()
	{
		//-------------------------
		// FAILED LOGINS CLUES
		// vars - [[USER]]
		//-------------------------
		$this->fail[0]['check_type']	= 'body';
		$this->fail[0]['check_for']	= 'username and password you entered are incorrect';
		$this->fail[0]['debug_msg']	= 'Incorrect User or Pass for user: [[USER]]';
	}

	/**************************
	 login
	***************************/
	function login(&$sms_obj)
	{

		$sms_obj->get_url($this->pre_login_script);
		if (preg_match('!^http://www\.vizzavi\.co\.uk/([^/]+)!', $sms_obj->http->get_info('redirect'), $match)) {
			$this->session_id = $match[1];
		} else {
			$sms_obj->debug('Could not match session id in HTML source, login failed');
			return array('error'=>SWS_ERR_UNKNOWN);
		}

		// add session id to vars
		$this->login_script = str_replace('[[SESS]]', $this->session_id, $this->login_script);
		$this->confirm_script = str_replace('[[SESS]]', $this->session_id, $this->confirm_script);
		$this->send_script = str_replace('[[SESS]]', $this->session_id, $this->send_script);
		$this->logout_script = str_replace('[[SESS]]', $this->session_id, $this->logout_script);
		$this->preconfirm_script = str_replace('[[SESS]]', $this->session_id, $this->preconfirm_script);

		// grab login string 
		$command = $this->login_command;
		$command = str_replace('[[USER]]', urlencode($sms_obj->get_username()), $command);
		$command = str_replace('[[PASS]]', urlencode($sms_obj->get_password()), $command);

		// send login
		$result = $sms_obj->post_url($this->login_script, $command);
		$redirect_url = $sms_obj->http->get_info('redirect');
		
		// check for incorrect login details
		if (is_array($this->fail)) {
			for ($x=0; $x < count($this->fail); $x++) {
				$check_in = ($this->fail[$x]['check_type'] == 'body') ? $result : $redirect_url;
				if (strstr($check_in, $this->fail[$x]['check_for']) != '') {
					$sms_obj->debug(str_replace('[[USER]]', $sms_obj->get_username(), $this->fail[$x]['debug_msg']));
					return array('error'=>SWS_ERR_USER_PASS);
				}
			}
		}

		if (!$redirect_url) {
			return false;
		}

		return true;
	}


	/**************************
	 send sms
	***************************/
	function send_sms($op, &$sms_obj)
	{
		// $op : array with keys: 'msg', 'num', 'ccode'
		// eg. 'msg'=>'test message', 'ccode'=>'+44', 'num'=>'7929342829'

		if (is_array($error = $this->login($sms_obj))) {
			$sms_obj->debug('Unable to log in');
			return $error;
		}

		$message = str_replace('[[MSG]]', $op['msg'], $this->send_message);

		$confirm_command = $this->confirm_command;
		$confirm_command = str_replace('[[NUM]]', urlencode('0'.$op['num']), $confirm_command);
		$confirm_command = str_replace('[[MSG]]', urlencode($message), $confirm_command);
		$confirm_command = str_replace('[[REMAIN]]', 110-strlen($message), $confirm_command);

		$command = $this->send_command;
		$command = str_replace('[[NUM]]', urlencode('0'.$op['num']), $command);
		$command = str_replace('[[MSG]]', urlencode($message), $command);

		$sms_obj->get_url($this->preconfirm_script);
		// confirm page not required
		//$result = $sms_obj->post_url($this->confirm_script, $confirm_command);
		$result = $sms_obj->post_url($this->send_script, $command);

		if (strstr($result, $this->success_string)) {
			$sms_obj->debug('SMS Message Sent Successfully');
			return true;
		} else {
			$sms_obj->debug('SMS Send Failed');
			if (strstr($result, $this->quota_exceeded_string)) {
				$sms_obj->debug('Quota for current user ['.$sms_obj->get_username().'] exceeded.');
				return array('error'=>SWS_ERR_QUOTA);
			}
			return array('error'=>SWS_ERR_SEND);
		}
	}

	/**************************
	 logout
	***************************/
	function logout(&$sms_obj)
	{
		$sms_obj->debug('Logging out...');
		$sms_obj->get_url($this->logout_script);
		return true;
	}
}
?>