<?php
/* vim: set ai tabstop=4: */
// $Date: 2002/05/11 02:27:07 $
// $Revision: 1.9 $
// +----------------------------------------------------------------------+
// | SMS WEB SENDER 0.4 - 11-May-2002                                     |
// +----------------------------------------------------------------------+
// | Author: Keyvan Minoukadeh - keyvan@k1m.com - http://www.k1m.com      |
// +----------------------------------------------------------------------+
// | This is PHP class which connects to a web site offering free SMS     |
// | sending, logs you in with your username and password and sends       |
// | your SMS message to a mobile number.                                 |
// |                                                                      |
// | Note: experimental class, haven't had a chance to test it properly   |
// |       yet, please let me know if you come across any problems, or    |
// |       have any comments, or if you've fixed/added something useful.  |
// |                                                                      |
// |                 *** see readme.txt for more info ***                 |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or        |
// | modify it under the terms of the GNU General Public License          |
// | as published by the Free Software Foundation; either version 2       |
// | of the License, or (at your option) any later version.               |
// |                                                                      |
// | This program is distributed in the hope that it will be useful,      |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+

// include files (if class files are not in same path define
// SWS_INCLUDE_PATH to point directory where these files are)
if (defined('SWS_INCLUDE_PATH')) {
	require_once(SWS_INCLUDE_PATH.'class.http_mini_navigator.php');
	require_once(SWS_INCLUDE_PATH.'class.site_base.php');
} else {
	trigger_error('SWS_INCLUDE_PATH not defined', E_USER_ERROR);
}

// errors
define('SWS_ERR_USER_PASS',	1);
define('SWS_ERR_QUOTA',		2);
define('SWS_ERR_SEND',		3);
define('SWS_ERR_UNKNOWN',	4);

class sms_web_sender
{
	var $http					= null;			// holds instance of HTTP navigator class
	var $site					= array();		// holds current site details
	var $site_obj				= null;			// holds instance of current site class
	var $sites					= array();		// holds all site details
	var $debug					= false;

	var $translate				= false;		// auto translate known words to shorter sms text
	var $translate_obj			= null;			// holds instance of translate object

	var $err_str				= array(SWS_ERR_USER_PASS	=> 'Incorrect username or password',
										SWS_ERR_QUOTA		=> 'Insufficient quota on account',
										SWS_ERR_SEND		=> 'Unable to send message',
										SWS_ERR_UNKNOWN		=> 'Unknown error occurred');
	var $last_error				= null;			// holds last error number

	/**
	* Get last error string
	*/
	function err_str()
	{
		if (is_null($this->last_error)) {
			return null;
		} else {
			return $this->err_str[$this->last_error];
		}
	}

	/**
	* Get last error number
	*/
	function err_num()
	{
		if (is_null($this->last_error)) {
			return null;
		} else {
			return $this->last_error;
		}
	}

	/**
	* Turn on debugging?
	*
	* @param	bool	$debug	true or false
	*/
	function set_debug($debug)
	{
		$this->debug = $debug;
		return true;
	}

	/**
	* Turn on auto translate?
	*
	* @param	bool	$translate	true or false
	*/
	function set_translate($translate)
	{
		if ($translate) {
			require_once(SWS_INCLUDE_PATH.'class.sms_dictionary.php');
			if (!is_object($this->translate_obj)) {
				$this->translate_obj = new sms_dictionary;
			}
			$this->translate = true;
		} else {
			$this->translate = false;
		}
		return true;
	}

	/**
	* CONSTRUCTOR
	*/
	// $server name will determine which class to use
	function sms_web_sender($debug=false)
	{
		// create instance of HTTP mini Navigator class
		$this->http = new http_navigator($debug);

		$this->set_translate($this->translate);

		if ($debug) {
			$this->set_debug(true);
		}
	}

	/**
	* Set site
	*/
	function set_site()
	{
		if (file_exists(SWS_INCLUDE_PATH.'class.site_'.$this->site['class'].'.php')) {
			require_once(SWS_INCLUDE_PATH.'class.site_'.$this->site['class'].'.php');
			set_time_limit(60);
			$this->http->clear();
			$this->http->del_old_cookies();
			$this->debug($this->site['class'].' class being used');
			$this->site_obj = new $this->site['class'];
			return true;
		} else {
			trigger_error("Site class '{$this->site['class']}' does not exist", E_USER_ERROR);
			return false;
		}
	}

	/**
	* Add site
	*
	* Pass an array holding these values:
	* ['class'] = site class
	* ['user'] = username for the site
	* ['pass'] = password for the site
	* ['weight'] = weight of the site (only useful if you call shuffle_logins()) (1=low, 10=high)
	* ['options'] = array holding any other specific options for this particular site
	*
	* @param	array	$site	array holding site details
	*/
	function add_site($site)
	{
		if (!isset($site['weight'])) {
			$site['weight'] = 1;
		}
		$this->sites[] = array_merge($site, array('id'=>count($this->sites)));
		return true;
	}

	/**
	* Shuffle sites
	*
	* Shuffle sites based on weight value of each site account
	*/
	function shuffle_logins()
	{
		$tmp_array = array();
		$shuffled = array();

		// create new array holding biased amount
		// of each login (based on weight)
		foreach ($this->sites as $site) {
			for ($x=1; $x<=$site['weight']; $x++) {
				$tmp_array[] = $site;
			}
		}

		// loop through logins randomly picking out
		// login details to put in the new array
		while (count($shuffled) < count($this->sites)) {
			mt_srand((double) microtime() * 1000000);
			$rand_pick = mt_rand(0, count($tmp_array));
			if ($rand_pick > 0) $rand_pick--;
			$remove_id = $tmp_array[$rand_pick]['id'];
			$shuffled[] = $tmp_array[$rand_pick];
			foreach ($tmp_array as $key=>$val) {
				if ($val['id'] == $remove_id) {
					unset($tmp_array[$key]);
				}
			}
			// reset the keys
			$tmp_array = array_values($tmp_array);
		}
		
		// replace our logins array with our shuffled array
		$this->sites = $shuffled;
		return true;
	}

	/**********************
	* GET USERNAME
	***********************/
	function get_username()
	{
		return $this->site['user'];
	}

	/**********************
	* GET PASSWORD
	***********************/
	function get_password()
	{
		return $this->site['pass'];
	}

	/**********************
	* GET SITE
	***********************/
	function get_site()
	{
		return $this->site['class'];
	}

	/**********************
	* NEXT SITE
	***********************/
	function next_site()
	{
		if (next($this->sites)) {
			$this->site = $this->sites[key($this->sites)];
			$this->debug('Advancing to next user.');
			return $this->set_site($this->get_site());
		} else {
			$this->debug('No more configured users.');
			return false;
		}
	}

	/**********************
	* DEBUG OUTPUT
	***********************/
	function debug($line)
	{
		if ($this->debug) {
			echo "SWS - $line<br>\n";
			flush();
		}
		return true;
	}

	/**********************
	* POST URL
	***********************/
	function post_url($url, $formdata)
	{
		if ($this->http->is_error($this->http->post_url($formdata, $url))) {
			return false;
		} else {
			return $this->http->get_headers().$this->http->_nl_rn.$this->http->_nl_rn.$this->http->get_body();
		}
	}

	/**********************
	* GET URL
	***********************/
	function get_url($url)
	{
		if ($this->http->is_error($this->http->get_url($url))) {
			return false;
		} else {
			return true;
		}
	}

	/**********************
	* SEND SMS
	***********************/
	function send_sms($options)
	{
		if (!is_object($this->site_obj)) {
			$this->site = $this->sites[key($this->sites)];
			$this->set_site();
		}

		if ($this->translate) {
			$options['msg'] = $this->translate_obj->translate($options['msg']);
		}			

		$result = $this->site_obj->send_sms($options, $this);
	
		if (is_array($result) && isset($result['error'])) {
			$this->last_error = $result['error'];
			$result = false;
		} elseif (!$result) {
			$this->last_error = SWS_ERR_UNKNOWN;
		}

		if (!$result && $this->next_site()) {
			return $this->send_sms($options);
		} else {
			return $result;
		}
	}

	/**********************
	* LOGOUT
	* not necessary for most stuff
	***********************/
	function logout()
	{
		return $this->site_obj->logout($this);
	}
}
?>
