<?php
/* vim: set ai tabstop=4: */
// $Date: 2002/05/11 02:20:46 $
// $Revision: 1.2 $

/**
* 1RSTWAP.COM class (21-APR-2002)
*/
class firstwap_com extends sms_base
{
	//-------------------------
	// LOGIN
	// vars - [[USER]] [[PASS]]
	//-------------------------
	var $login_pre = 'http://www.1rstwap.com/partners/go.to/1rstwap';
	var $login_script = 'http://www.1rstwap.com/partners/go.php?sestime=[[TS]]&pid=login';
	var $login_command = 'UserID=[[USER]]&Passwd=[[PASS]]&submitButtonName=Sign+In&pid%3Dfirst&cobid=1RSTWAP';

	//-------------------------
	// SEND SMS
	// vars - [[TIMESTAMP]] [[GSM_NUMBER]] [[MESSAGE]] [[SIG]]
	//-------------------------
	// check for success string
	var $success_string = 'message has been sent to';

	// check for quota string
	// DO NOT KNOW MATCHING STRING
	var $quota_exceeded_string = 'limit has been reached';

	// form page
	var $send_pre = 'http://www.1rstwap.com/partners/go.php?pid=addressbook&aid=smswindow&step=openfmenu'; 

	// send command
	var $send_command = 'hp=[[NUM]]&COUNTER=[[COUNTER]]&m=[[MSG]]&submitButtonName=Send&SENDER=[[NUM]]';

	// send flash
	var $send_command_flash = 'hp=[[NUM]]&COUNTER=[[COUNTER]]&flashsms=1&m=[[MSG]]&submitButtonName=Send&SENDER=[[NUM]]';

	// send URL
	var $send_script = 'http://www.1rstwap.com';

	// message
	var $send_message = '[[MSG]]';

	// logout URL
	// UNTESTED
	var $logout_script = 'http://www.1rstwap.com/partners/go.php?pid=logout';

	// failure checks
	var $fail = array();

	
	/**************************
	 constructor
	***************************/
	function sms_ac()
	{
		//-------------------------
		// FAILED LOGINS CLUES
		// vars - [[USER]]
		//-------------------------
		$this->fail[0]['check_type']	= 'body';
		$this->fail[0]['check_for']	= 'Invalid User ID, please';
		$this->fail[0]['debug_msg']	= 'Incorrect user: [[USER]]';
		$this->fail[1]['check_type']	= 'body';
		$this->fail[1]['check_for']	= 'Password is invalid, please';
		$this->fail[1]['debug_msg']	= 'Incorrect password for user: [[USER]]';
	}

	/**************************
	 login
	***************************/
	function login(&$sms_obj)
	{
		// get cookie set
		$sms_obj->get_url($this->login_pre);

		$this->login_script = str_replace('[[TS]]', time(), $this->login_script);

		// grab login string 
		$command = $this->login_command;
		$command = str_replace('[[USER]]', urlencode($sms_obj->get_username()), $command);
		$command = str_replace('[[PASS]]', urlencode($sms_obj->get_password()), $command);

		// send login
		$result = $sms_obj->post_url($this->login_script, $command);

		// check for incorrect login details
		if (is_array($this->fail)) {
			for ($x=0; $x < count($this->fail); $x++) {
				$check_in = ($this->fail[$x]['check_type'] == 'body') ? $result : $redirect_url;
				if (strstr($check_in, $this->fail[$x]['check_for']) != '') {
					$sms_obj->debug(str_replace('[[USER]]', $sms_obj->get_username(), $this->fail[$x]['debug_msg']));
					return array('error'=>SWS_ERR_USER_PASS);
				}
			}
		}

		return true;
	}

	/**************************
	 send sms
	***************************/
	function send_sms($op, &$sms_obj)
	{
		// $op : array with keys: 'msg', 'num', 'ccode'
		// eg. 'msg'=>'test message', 'ccode'=>'+44', 'num'=>'7929342829'

		if (is_array($error = $this->login($sms_obj))) {
			$sms_obj->debug('Unable to log in');
			return $error;
		}

		$sms_obj->get_url($this->send_pre);
		if (preg_match('/action="([^"]+)"/', $sms_obj->http->get_body(), $match)) {
			$this->send_script .= $match[1];
		} else {
			return array('error'=>SWS_ERR_SEND);
		}

		// flash it?
		if (isset($sms_obj->site['options']['flash']) && $sms_obj->site['options']['flash'] === true) {
			$this->send_command = $this->send_command_flash;
		}

		$message = str_replace('[[MSG]]', $op['msg'], $this->send_message);

		$command = $this->send_command;
		$command = str_replace('[[NUM]]', urlencode(str_replace('+', '', $op['ccode'].$op['num'])), $command);
		$command = str_replace('[[MSG]]', urlencode($message), $command);
		$command = str_replace('[[COUNTER]]', 160-strlen($op['msg']), $command);

		$result = $sms_obj->post_url($this->send_script, $command);
		
		if (strstr($result, $this->success_string)) {
			$sms_obj->debug('SMS Message Sent Successfully');
			return true;
		} else {
			$sms_obj->debug('SMS Send Failed');
			if (strstr($result, $this->quota_exceeded_string)) {
				$sms_obj->debug('Quota for current user ['.$sms_obj->get_username().'] exceeded.');
				return array('error'=>SWS_ERR_QUOTA);
			}
			return array('error'=>SWS_ERR_SEND);
		}
	}

	/**************************
	 logout
	***************************/
	function logout(&$sms_obj)
	{
		$sms_obj->debug('Logging out...');
		$sms_obj->get_url($this->logout_script);
		return true;
	}
}
?>