<?php
/* vim: set ai tabstop=4: */
// $Date: 2002/05/11 02:20:46 $
// $Revision: 1.2 $

/**
* GENIE.CO.UK class (21-APR-2002)
*/
class genie_co_uk extends sms_base
{
	//-------------------------
	// LOGIN
	// vars - [[USER]] [[PASS]]
	//-------------------------
	var $pre_login_script = "http://www.genie.co.uk/";
	var $login_script = "http://www.genie.co.uk/login/doLogin";
	var $login_command = "username=[[USER]]&password=[[PASS]]&x=9&y=9";

	//-------------------------
	// SEND SMS
	// vars - [[NUM]] [[MSG]]
	//-------------------------
	// check for success string
	var $success_string = "been%20sent%20successfully";

	// check for quota string
	var $quota_exceeded_string = "You tried to send";

	// send command
	var $send_command = "contact=&RECIPIENT=[[NUM]]&SUBJECT=&MESSAGE=[[MSG]]&action=Send&check=0&numbers=&noOfPhones=";

	// send URL
	var $send_script = "http://sendsms.genie.co.uk/cgi-bin/sms/send_sms.cgi";

	// message
	var $send_message = "[[MSG]]";

	// logout URL
	var $logout_script = "http://www.genie.co.uk/logout/";

	// failure checks
	var $fail = array();

	
	/**************************
	 constructor
	***************************/
	function genie_co_uk()
	{
		//-------------------------
		// FAILED LOGINS CLUES
		// vars - [[USER]]
		//-------------------------
		$this->fail[0]["check_type"]= 'body';
		$this->fail[0]["check_for"]	= 'User Name and/or Password you entered';
		$this->fail[0]["debug_msg"]	= 'Incorrect user/pass for user: [[USER]]';
	}

	/**************************
	 login
	***************************/
	function login(&$sms_obj)
	{
		// grab login string 
		$command = $this->login_command;
		$command = str_replace('[[USER]]', urlencode($sms_obj->site['user']), $command);
		$command = str_replace('[[PASS]]', urlencode($sms_obj->site['pass']), $command);

		$result = $sms_obj->post_url($this->login_script, $command);
		$redirect_url = $sms_obj->http->get_info('redirect');
		
		// check for incorrect login details
		if (is_array($this->fail)) {
			for ($x=0; $x < count($this->fail); $x++) {
				$check_in = ($this->fail[$x]['check_type'] == 'body') ? $result : $redirect_url;
				if (strstr($check_in, $this->fail[$x]['check_for']) != '') {
					$sms_obj->debug(str_replace('[[USER]]', $sms_obj->site['user'], $this->fail[$x]['debug_msg']));
					return array('error'=>SWS_ERR_USER_PASS);
				}
			}
		}

		if (!$redirect_url) {
			return array('error'=>SWS_ERR_UNKNOWN);
		}

		return true;
	}

	/**************************
	 send sms
	***************************/
	function send_sms($op, &$sms_obj)
	{
		// $op : array with keys: 'msg', 'num', 'ccode'
		// eg. 'msg'=>'test message', 'ccode'=>'+44', 'num'=>'7929342829'
		
		if (is_array($error = $this->login($sms_obj))) {
			$sms_obj->debug('Unable to log in');
			return $error;
		}

		$tmp_message = $this->send_message;
		$tmp_message = str_replace('[[MSG]]', $op['msg'], $tmp_message);

		$message = $tmp_message;

		$command = $this->send_command;
		$command = str_replace('[[NUM]]', urlencode('0'.$op['num']), $command);
		$command = str_replace('[[MSG]]', urlencode($message), $command);

		$result = $sms_obj->post_url($this->send_script, $command);
		if (strstr($result, $this->success_string)) {
			$sms_obj->debug('SMS Message Sent Successfully');
			return true;
		} else {
			$sms_obj->debug('SMS Send Failed');
			if (strstr($result, $this->quota_exceeded_string)) {
				$sms_obj->debug('Quota for current user ['.$sms_obj->get_username().'] exceeded.');
				array('error'=>SWS_ERR_QUOTA);
			}
			return array('error'=>SWS_ERR_SEND);
		}
	}

	/**************************
	 logout
	***************************/
	function logout(&$sms_obj)
	{
		$sms_obj->debug('Logging out...');
		$sms_obj->get_url($this->logout_script);
		return true;
	}
}
?>