<?php
/*
$Date: 2002/05/11 02:20:46 $
$Revision: 1.5 $

This is an example file showing you how to use
the class...
*/

// define sms web sender include path
// if you don't want to modify the sms web sender class
// just set this to the directory where you've put:
// class.http_mini_navigator.php and sites.php
// must include trailing slash (unless empty)
define('SWS_INCLUDE_PATH', '');

// contains main class
require_once(SWS_INCLUDE_PATH.'class.sms_web_sender.php');

// country prefix
$prefix = '+44';

// your mobile number, excluding leading '0'
// no spaces in between
$number = '7911111111';

// main body of the message
$message = 'Test message';

// create instance of sms web sender the one
// optional argument will determine if
// debug is turned on or not
$sms = new sms_web_sender(true);

// add accounts
// ['user']:    username
// ['pass']:    password
// ['class']:   site class name (eg. genie_co_uk)
// ['weight']:  (optional) weight, only useful when
//              shuffling the logins, the higher
//              the weight, the more likely it'll
//              be placed near the top of the list.
//              default if left blank: 1
// ['options']: (optional) extra options site can use
$sms->add_site(array('user'=>'myuser', 'pass'=>'mypass', 'class'=>'breathe_com'));
$sms->add_site(array('user'=>'myuser', 'pass'=>'mypass', 'class'=>'vizzavi_co_uk'));
$sms->add_site(array('user'=>'myuser', 'pass'=>'mypass', 'class'=>'genie_co_uk'));
$sms->add_site(array('user'=>'myuser', 'pass'=>'mypass', 'class'=>'lycos_co_uk', 'weight'=>1));
$sms->add_site(array('user'=>'myuser', 'pass'=>'mypass', 'class'=>'sms_ac', 'weight'=>4));
$sms->add_site(array('user'=>'myuser', 'pass'=>'mypass', 'class'=>'firstwap_com', 'options'=>array('flash'=>false)));

// shuffle logins
$sms->shuffle_logins();

// auto translate message
$sms->set_translate(false);

// passes the number, signature and message in an array
$result = $sms->send_sms(array('num'=>$number, 'ccode'=>$prefix, 'msg'=>$message));

// check if result was successul
if ($result) {
	echo "Success!";
} else {
	// result was not successful
	// to see last error encountered use: err_str()
	// You can check for a specific error using err_num(),
	// SWS_ERR_USER_PASS - Incorrect user or pass
	// SWS_ERR_QUOTA - Quota exceeded
	// SWS_ERR_SEND - Error sending
	// SWS_ERR_UNKNOWN - Uknown error
	if ($sms->err_num() === SWS_ERR_USER_PASS) {
		echo "Last error was due to incorrect username or password";
	} else {
		echo $sms->err_str();
	}
}

?>